package com.ejie.ab04b.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.exception.ErrorField;
import com.ejie.ab04b.exception.ErrorGenericoException;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.Promotor;
import com.ejie.ab04b.service.PromotorService;
import com.ejie.ab04b.util.ValidadorNifCifNie;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * PromotorController generated by UDA, 21-feb-2017 13:23:34.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/promotor")
public class PromotorController {

	private static final Logger logger = LoggerFactory
			.getLogger(PromotorController.class);

	@Autowired()
	private PromotorService ab0485s00Service;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}
	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 *  terexp085
	 *            String
	 *  anoexp085
	 *            String
	 *  numexp085
	 *            Integer
	 *  tipdoc085
	 *            String
	 *  numdoc085
	 *            String
	 *
	 * @param terexp085 the terexp 085
	 * @param anoexp085 the anoexp 085
	 * @param numexp085 the numexp 085
	 * @param tipdoc085 the tipdoc 085
	 * @param numdoc085 the numdoc 085
	 *  Promotor Objeto correspondiente al identificador indicado.
	 * @return the promotor
	 */
	@RequestMapping(value = "/{terexp085}/{anoexp085}/{numexp085}/{tipdoc085}/{numdoc085}", method = RequestMethod.GET)
	public @ResponseBody() Promotor get(@PathVariable() String terexp085,
			@PathVariable() String anoexp085, @PathVariable() Integer numexp085,
			@PathVariable() String tipdoc085,
			@PathVariable() String numdoc085) {
		Promotor ab0485s00 = new Promotor();
		ab0485s00.setTerexp085(terexp085);
		ab0485s00.setAnoexp085(anoexp085);
		ab0485s00.setNumexp085(numexp085);
		ab0485s00.setTipdoc085(tipdoc085);
		ab0485s00.setNumdoc085(numdoc085);
		ab0485s00 = this.ab0485s00Service.find(ab0485s00);
		PromotorController.logger
				.info("[GET - findBy_PK] : Obtener Promotor por PK");
		return ab0485s00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 *  filterPromotor
	 *            Promotor Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 *
	 * @param filterPromotor the filter promotor
	 *  List<Promotor> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody() List<Promotor> getAll(
			@ModelAttribute() Promotor filterPromotor) {
		PromotorController.logger
				.info("[GET - find_ALL] : Obtener Promotor por filtro");
		return this.ab0485s00Service.findAll(filterPromotor, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 *  ab0485s00
	 *            Promotor Bean que contiene la informacion a modificar.
	 * 
	 *  request
	 *            HttpServletRequest
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @param request the request
	 *  Promotor Bean resultante de la modificacion.
	 * @return the promotor
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() Promotor edit(@RequestBody() Promotor ab0485s00,
			HttpServletRequest request) {
		Promotor ab0485s00Aux = this.ab0485s00Service.update(ab0485s00);
		PromotorController.logger
				.info("[PUT] : Promotor actualizado correctamente");
		return ab0485s00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 *  ab0485s00
	 *            Promotor Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 *  request
	 *            HttpServletRequest
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @param request the request
	 *  Promotor Bean resultante del proceso de creacion.
	 * @return the promotor
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() Promotor add(@RequestBody() Promotor ab0485s00,
			HttpServletRequest request) {

		HttpSession session = request.getSession();
		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			if (comunicAperturaSess != null) {
				ab0485s00.setTerexp085(comunicAperturaSess.getTerape056());
				ab0485s00.setAnoexp085(comunicAperturaSess.getAnoape056());
				ab0485s00.setNumexp085(
						comunicAperturaSess.getNumape056().intValue());
				if (comunicAperturaSess.getCodobra056() != null) {
					ab0485s00
							.setCodobra085(comunicAperturaSess.getCodobra056());
				}
			}

		}
		Promotor ab0485s00Aux = new Promotor();

		// Validate
		List<ErrorField> errores = this.validateEditAdd(ab0485s00);
		if (errores != null && !errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		// validar que no exista un proyectista para la obra sin fecha baja
		Promotor promFind = new Promotor();
		promFind.setTerexp085(ab0485s00.getTerexp085());
		promFind.setAnoexp085(ab0485s00.getAnoexp085());
		promFind.setNumexp085(ab0485s00.getNumexp085());
		promFind.setTipdoc085(ab0485s00.getTipdoc085());
		promFind.setNumdoc085(ab0485s00.getNumdoc085());
		promFind.setCodobra085(ab0485s00.getCodobra085());
		// proyFind.setFecbaj083(new Date());
		List<Promotor> listaProyectistas = this.ab0485s00Service
				.findAll(promFind, null);

		if (listaProyectistas != null && listaProyectistas.size() > 0) {
			errores.add(new ErrorField("aperturas.detalle.promotor",
					"error.promotor.activo"));

			if (!errores.isEmpty()) {
				throw new ErrorGenericoException(errores);
			}
		}

		try {
			ab0485s00.setUsualt085("prueba");
			ab0485s00Aux = this.ab0485s00Service.add(ab0485s00);
		} catch (Exception e) {
			throw new ErrorGenericoException("");
		}

		PromotorController.logger
				.info("[POST] : Promotor insertado correctamente");
		return ab0485s00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 *  terexp085
	 *            String
	 *  anoexp085
	 *            String
	 *  numexp085
	 *            Integer
	 *  tipdoc085
	 *            String
	 *  numdoc085
	 *            String
	 *  request
	 *            HttpServletRequest
	 *
	 * @param terexp085 the terexp 085
	 * @param anoexp085 the anoexp 085
	 * @param numexp085 the numexp 085
	 * @param tipdoc085 the tipdoc 085
	 * @param numdoc085 the numdoc 085
	 * @param request the request
	 *  Promotor Bean eliminado.
	 * @return the promotor
	 */
	@RequestMapping(value = "/{terexp085}/{anoexp085}/{numexp085}/{tipdoc085}/{numdoc085}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() Promotor remove(@PathVariable() String terexp085,
			@PathVariable() String anoexp085, @PathVariable() Integer numexp085,
			@PathVariable() String tipdoc085, @PathVariable() String numdoc085,
			HttpServletRequest request) {

		HttpSession session = request.getSession();
		Promotor ab0485s00 = new Promotor();
		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			if (comunicAperturaSess != null
					&& comunicAperturaSess.getCodobra056() != null) {
				ab0485s00.setCodobra085(comunicAperturaSess.getCodobra056());
			}

		}

		ab0485s00.setTerexp085(terexp085);
		ab0485s00.setAnoexp085(anoexp085);
		ab0485s00.setNumexp085(numexp085);
		ab0485s00.setTipdoc085(tipdoc085);
		ab0485s00.setNumdoc085(numdoc085);

		this.ab0485s00Service.remove(ab0485s00);
		PromotorController.logger
				.info("[DELETE] : Promotor borrado correctamente");
		return ab0485s00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		PromotorController.logger.info("[GET - View] : ab0485s00");
		return "ab0485s00";
	}

	/**
	 * Buscar promotor.
	 * 
	 *  tipoIdentif            String
	 *  numeroDocumento            String
	 *
	 * @param tipoIdentif the tipo identif
	 * @param numeroDocumento the numero documento
	 *  Ramas
	 * @return the promotor
	 */
	@RequestMapping(value = "buscarPromotor", method = RequestMethod.GET)
	public @ResponseBody() Promotor buscarPromotor(
			@RequestParam(value = "tipoIdentif") String tipoIdentif,
			@RequestParam(value = "numeroDocumento") String numeroDocumento) {
		Promotor promotorFind = new Promotor();
		promotorFind.setTipdoc085(tipoIdentif);
		promotorFind.setNumdoc085(numeroDocumento);

		List<Promotor> listaPromotores = this.ab0485s00Service
				.findPromotorMaxFecAlta(promotorFind);

		if (listaPromotores != null && listaPromotores.size() > 0) {
			return listaPromotores.get(0);
		} else {

			throw new ErrorGenericoException("");
		}
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterPromotor
	 *            Promotor Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *  request
	 *            HttpServletRequest
	 *
	 * @param filterPromotor the filter promotor
	 * @param jqGridRequestDto the jq grid request dto
	 * @param request the request
	 *  JQGridResponseDto<Promotor> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<Promotor> filter(
			@RequestJsonBody(param = "filter") Promotor filterPromotor,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request) {
		PromotorController.logger.info("[POST - filter] : Obtener Promotors");

		HttpSession session = request.getSession();

		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			if (comunicAperturaSess != null) {
				filterPromotor.setAnoexp085(comunicAperturaSess.getAnoape056());
				filterPromotor.setTerexp085(comunicAperturaSess.getTerape056());
				filterPromotor.setNumexp085(
						comunicAperturaSess.getNumape056().intValue());
				filterPromotor
						.setCodobra085(comunicAperturaSess.getCodobra056());
			}

		}

		return this.ab0485s00Service.filter(filterPromotor, jqGridRequestDto,
				false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 *  filterPromotor
	 *            Promotor Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  searchPromotor
	 *            Promotor Bean que contiene los parametros de busqueda a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 *
	 * @param filterPromotor the filter promotor
	 * @param searchPromotor the search promotor
	 * @param jqGridRequestDto the jq grid request dto
	 *  TableRowDto<Promotor> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 * @return the list
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody() List<TableRowDto<Promotor>> search(
			@RequestJsonBody(param = "filter") Promotor filterPromotor,
			@RequestJsonBody(param = "search") Promotor searchPromotor,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		PromotorController.logger.info("[POST - search] : Buscar Promotors");
		return this.ab0485s00Service.search(filterPromotor, searchPromotor,
				jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros.
	 * 
	 *  filterPromotor            Promotor Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 *
	 * @param filterPromotor the filter promotor
	 * @param jqGridRequestDto the jq grid request dto
	 *  List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * @return the list
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Promotor filterPromotor,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		PromotorController.logger.info(
				"[POST - search] : [POST - removeMultiple] : Eliminar multiples Promotors");
		this.ab0485s00Service.removeMultiple(filterPromotor, jqGridRequestDto,
				false);
		PromotorController.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 *  filterPromotor
	 *            Promotor Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterPromotor the filter promotor
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<JerarquiaDto<Promotor>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<JerarquiaDto<Promotor>> jerarquia(
			@RequestJsonBody(param = "filter") Promotor filterPromotor,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		PromotorController.logger
				.info("[POST - jerarquia] : Obtener Promotors jerarquia");
		return this.ab0485s00Service.jerarquia(filterPromotor, jqGridRequestDto,
				false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 *  filterPromotor
	 *            Promotor Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterPromotor the filter promotor
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<JerarquiaDto<Promotor>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<JerarquiaDto<Promotor>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Promotor filterPromotor,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		PromotorController.logger.info(
				"[POST - jerarquia] : Obtener Promotors jerarquia - Hijos");
		return this.ab0485s00Service.jerarquiaChildren(filterPromotor,
				jqGridRequestDto);
	}

	/**
	 * Validate edit add.
	 * 
	 *  promotor            Promotor
	 *
	 * @param promotor the promotor
	 *  List<ErrorField>
	 * @return the list
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity
	private List<ErrorField> validateEditAdd(Promotor promotor) {
		List<ErrorField> errorFields = new ArrayList<ErrorField>();

		if (promotor.getTipdoc085() == null) {
			errorFields.add(new ErrorField("aperturas.detalle.tipoIdentif",
					"error.tipocifnif"));
		}
		if (promotor.getNumdoc085() == null) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"validacion.obligatorio"));

		} else if (promotor.getNumdoc085() != null
				&& Constantes.TIPO_CIF.equals(promotor.getTipdoc085())
				&& !ValidadorNifCifNie.isCifValido(promotor.getNumdoc085())) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"error.cif.incorrecto"));
		} else if (promotor.getNumdoc085() != null
				&& Constantes.TIPO_NIF.equals(promotor.getTipdoc085())
				&& !ValidadorNifCifNie.isNifValido(promotor.getNumdoc085())) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"error.nif.incorrecto"));
		}
		if (promotor.getTipoprm085() != null) {
			promotor.setTipoprm085(Constantes.PROMOTOR_PRINCIPAL);
			if (this.ab0485s00Service
					.buscarHayPromotorPrincipal(promotor) != 0) {
				errorFields.add(new ErrorField("aperturas.detalle.promotores",
						"error.promotor.principal"));
			}
		}

		if (promotor.getPaisprm085() != null
				&& Constantes.ID_PAIS_ESPANA.equals(promotor.getPaisprm085())) {
			if (promotor.getCodProvincia() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.provincia",
						"validacion.obligatorio"));
			}
			if (promotor.getCodMunicipio() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.municipio",
						"validacion.obligatorio"));
			}
		} else {
			if (promotor.getDmunprm085() == null
					|| "".equals(promotor.getDmunprm085())) {
				errorFields
						.add(new ErrorField("aperturas.detalle.munipExtranjero",
								"validacion.obligatorio"));
			}
		}

		return errorFields;
	}

}
